<?php $__env->startSection('page_title', 'Wallet'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">Wallet</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Wallet</li>
                    </ol>
                </div>
            </div>

            <!-- Search -->
            <form action="<?php echo e(route('wallet.index')); ?>" method="GET">
                <div class="page-search mb-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                                <i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i>
                            </span>
                        </div>
                        <input type="text" name="input_search" value="<?php if(isset($_GET['input_search'])): ?><?php echo e($_GET['input_search']); ?><?php endif; ?>" class="form-control" placeholder="Search User Name, Email, Mobile Number, Coin" aria-label="Search" aria-describedby="basic-addon1">
                    </div>
                    <button class="btn btn-default" type="submit">SEARCH</button>
                </div>
            </form>

            <div class="row">
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-lg-6">
                    <div class="card p-4 video-card">
                        <div class="media text-secondary">
                            <img src="<?php echo e($value->image); ?>" class="mr-3 wallet-image" alt="Avatar Image">
                            <div class="media-body card-body pt-0">
                                <h4 class="mt-0 mb-2 text-dark card-title"><?php echo e($value->user_name); ?></h4>
                                <ul class="list-unstyled">
                                    <li class="d-flex mb-1">
                                        <span><?php echo e($value->email); ?></span>
                                    </li>
                                    <li class="d-flex mb-1">
                                        <span><?php echo e($value->mobile_number); ?></span>
                                    </li>
                                    <li class="d-flex">
                                        <span><b>Coin : <?php echo e($value->wallet_coin); ?></b></span>
                                    </li>
                                </ul>

                                <a href="<?php echo e(route('wallet.transaction', $value->id)); ?>" class="btn btn-md mw-150" style="background:#058f00; color:#fff; font-weight:bold; border:none">
                                    Transaction
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center">
                <div> Showing <?php echo e($data->firstItem()); ?> to <?php echo e($data->lastItem()); ?> of total <?php echo e($data->total()); ?> entries </div>
                <div class="pb-5"> <?php echo e($data->links()); ?> </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/admin/wallet/index.blade.php ENDPATH**/ ?>