<?php $__env->startSection('page_title', __('Label.Notification_Setting')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('Label.Notification_Setting')); ?></h1>

            <div class="border-bottom row">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('notification.index')); ?>"><?php echo e(__('Label.Notification')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Label.Notification_Setting')); ?></li>
                    </ol>
                </div>
            </div>

            <div class="card custom-border-card mt-3">
                <form id="notification-setting" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Onesignal app id</label>
                                <input name="onesignal_apid" type="text" class="form-control" value="<?php if($result): ?><?php echo e($result['onesignal_apid']); ?><?php endif; ?>" placeholder="Enter Onesignal app id" autofocus>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Onesignal reset key</label>
                                <input name="onesignal_rest_key" type="text" class="form-control" value="<?php if($result): ?><?php echo e($result['onesignal_rest_key']); ?><?php endif; ?>" placeholder="Enter Onesignal reset key">
                            </div>
                        </div>
                    </div>
                    <div class="border-top pt-3 text-right">
                        <button type="button" class="btn btn-default mw-120" onclick="notification_setting()"><?php echo e(__('Label.SAVE')); ?></button>
                        <a href="<?php echo e(route('notification.index')); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>
        function notification_setting() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if (Check_Admin == 1) {
                $("#dvloader").show();
                var formData = new FormData($("#notification-setting")[0]);
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("notification.settingsave")); ?>',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'notification-setting', '<?php echo e(route("notification.index")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown.msg, 'failed');
                    }
                });
            } else {
                toastr.error('You have no right to add, edit, and delete.');
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/admin/notification/setting.blade.php ENDPATH**/ ?>