
<?php $__env->startSection('page_title',  'Profile'); ?>

<?php $__env->startSection('content'); ?>
	<?php echo $__env->make('artist.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<div class="right-content">
		<?php echo $__env->make('artist.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">Profile</h1>

			<div class="border-bottom row mb-3">
				<div class="col-sm-12">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="<?php echo e(route('artist.dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a></li>
						<li class="breadcrumb-item active" aria-current="page">Profile</li>
					</ol>
				</div>
			</div>

            <div class="card custom-border-card">
                <form id="profile" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="id" value="<?php if($data): ?><?php echo e($data->id); ?><?php endif; ?>">
                    <h5 class="card-header">Edit Profile</h5>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="col-md-9">
                                <div class="form-row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>User Name<span class="text-danger">*</span></label>
                                            <input type="text" name="user_name" value="<?php if($data): ?><?php echo e($data->user_name); ?><?php endif; ?>" class="form-control" placeholder="Enter User Name" autofocus>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Instagram URL<span class="text-danger">*</span></label>
                                            <input type="text" name="instagram_url" value="<?php if($data): ?><?php echo e($data->instagram_url); ?><?php endif; ?>" class="form-control" placeholder="Enter URL">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Facebook URL<span class="text-danger">*</span></label>
                                            <input type="text" name="facebook_url" value="<?php if($data): ?><?php echo e($data->facebook_url); ?><?php endif; ?>" class="form-control" placeholder="Enter URL">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label><?php echo e(__('Label.Bio')); ?><span class="text-danger">*</span></label>
                                            <textarea name="bio" rows="1" class="form-control" placeholder="Describe Your Self..."><?php if($data): ?><?php echo e($data->bio); ?><?php endif; ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group ml-5">
                                    <label class="ml-5">Image<span class="text-danger">*</span></label>
                                    <div class="avatar-upload ml-5">
                                        <div class="avatar-edit">
                                            <input type='file' name="image" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                            <label for="imageUpload" title="Select File"></label>
                                        </div>
                                        <div class="avatar-preview">
                                            <img src="<?php echo e($data->image); ?>" alt="upload_img.png" id="imagePreview">
                                        </div>
                                    </div>
                                    <input type="hidden" name="old_image" value="<?php if($data): ?><?php echo e($data->image); ?><?php endif; ?>">
                                    <label class="mt-3 ml-5 text-gray">Maximum size 2MB.</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="border-top pt-3 text-right">
                        <button type="button" class="btn btn-default mw-120" onclick="update_profile()"><?php echo e(__('Label.UPDATE')); ?></button>
                        <input type="hidden" name="_method" value="PATCH">
                    </div>
                </form>
            </div>
        </div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
	<script>
		function update_profile(){
			$("#dvloader").show();
			var formData = new FormData($("#profile")[0]);

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				enctype: 'multipart/form-data',
				type: 'POST',
				url: '<?php echo e(route("aprofile.update", [$data->id])); ?>',
				data: formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'profile', '<?php echo e(route("aprofile.index")); ?>');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('artist.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/artist/profile/index.blade.php ENDPATH**/ ?>